# Backup & Restore

## How do I move a user to a new server?

The current restore function accepts backups generated by both VestaCP
and HestiaCP.

1. Create a user backup on the old server.

   ```bash
   v-backup-user username
   ```

2. Copy the generated tarball to the new server and place it in `/backup`.

   ```bash
   scp /backup/username.2020.01.01-00-00.tar root@host.domain.tld:/backup/
   ```

3. Restore the backup on the new server. You can restore to a different user by changing the username in the command.

   ```bash
   v-restore-user username username.2020.01.01-00-00.tar
   ```

User accounts that do not exist will be created.

## What kind of backups are able to be restored?

Currently HestiaCP only support restoring backups made using:

1. HestiaCP
2. VestaCP

## How to edit the number of backups?

To edit the number of backups, please read the [Packages](../user-guide/packages) and [Users](../user-guide/users) documentation. You will need to create or edit a package, and assign it to the desired user.

## Not enough disk space available to preform the backup

For safety reasons, Hestia takes into account 2x the user’s disk usage when creating a backup. Therefore, before starting a backup, we check how much disk usage a user has left. If you encounter this error, you can do one of the following to solve the issue:

- Reduce the amount of backups saved per user saved.
- Move the backups to a remote storage.
- Move the backup folder to a different drive.
- Split up the user in multiple users.
- Exclude certain folders or mail accounts from the backup.

## What is the difference between zstd and gzip

zstd was developed by Facebook as a replacement for gzip. During our testing, we found a significant speed increase and lower disk space usage when compared to gzip.

For more information see [the zstd repo](https://github.com/facebook/zstd).

## What is the optimal compression ratio

The higher the number how better the compression ratio. During our testing, we discoverd that zstd level 3 is similar to level 9 for disk space, however it is much faster. zstd level 11 took about the same time, but gave us a smaller size. Levels higher than 19 should never be used, as zstd then becomes terribly slow.

## What kind of protocols are currently supported

Currently supported backup protocols are:

- FTP
- SFTP
- Rclone, which supports up to 50 different cloud providers. [See its documentation](https://rclone.org)

## How to setup an FTP backup server

Login via SSH and run the following command as root:

```bash
v-add-backup-host 'ftp' 'remote.ftp-host.tld' 'backup-user' 'p4ssw0rd' '/path-backups/' 'port'
```

### How to setup an SFTP backup server

::: warning
Please note passwords are stored as **plain text** on the server. They are only accessible by the root user, but if you want to use a more secure authentication method, use public and private keys.
:::

Login via SSH and run the following command as root:

```bash
v-add-backup-host 'sftp' 'remote.ftp-host.tld' 'backup-user' 'p4ssw0rd' '/path-backups/' 'port'
```

If using public and private keys (recommended):

```bash
v-add-backup-host 'sftp' 'remote.ftp-host.tld' 'backup-user' '/root/id_rsa' '/path-backups/' 'port'
```

## How to setup Rclone

::: tip
Initial configuration can only be done via CLI. After that, you can update the settings via the web panel.
:::

First, [download Rclone](https://rclone.org/downloads/). The easiest method is to run this command:

```bash
sudo -v
curl https://rclone.org/install.sh | sudo bash
```

Once the download and installation is complete, run `rclone config` as the `root` user and then select the option `n`. Follow the instruction on the screen, then save when completed.

To verify if it is working run as intended:

```bash
echo "test" > /tmp/backuptest.txt
rclone cp /tmp/backuptest.txt $HOST:$FOLDER/backuptest.txt
rclone lsf $HOST:$FOLDER
```

And see the file has been uploaded

```bash
rclone delete $HOST:$FOLDER/backuptest.txt
```

Once the config has been saved you can setup Hestia with the following command:

```bash
v-add-backup-host 'rclone' 'remote-name' '' '' 'Bucket or Folder name' ''
```

::: tip
Configuration per endpoint might be different! Make sure to test it is working before relying on it. To verify it works run

```bash
v-backup-user admin
```

:::

For example:

```bash
rclone config

Current remotes:

Name Type
==== ====
r2 s3
```

To use the "R2" endpoint use

```bash
v-add-backup-host 'rclone' 'r2' '' '' 'folder'
```

For Blackblaze use

```bash
v-add-backup-host 'rclone' 'b2' '' '' 'hestiacp'
```

## Setting up Incremental Backups

Enable Incremental Backups in the user packages.

### Using Rclone

Since 1.9 we include Rclone by default in Hestia Installation. Run `rclone config` as the `root` user and then select the option `n`. Follow the instruction on the screen, then save when completed.

Run the following command:

```bash
v-add-backup-host-restic 'rclone:target:/folder/' '30' '8' '5' '3' '-1'
```

```bash
v-backup-users-restic
```

or

```bash
v-backup-user-restic username
```

:::warning
A new restic repository is initiated on the first time you run this command. An encryption key is generated at the same time in /usr/local/hestia/data/users/{users}/restic.conf. Please make sure to backup this file somewhere incase the server gets comprimised or the user gets deleted. Without this "secret" key we don't provide any method to restore the user data. This is the reason why we alway advice to keep the orignal backup still working.
:::

### Other methods

Other methods as long Restic supports it are supported how ever as we run the command as root we are not able to provide keys / password and so on before hand. This is why Rclone is in favor for other methods!

## How to change default backup folder

For security reasons, symlinks are not allowed. To change the default backup folder, you can do the following:

1. Make sure backup folder is currently set to `/backup`.
2. If it has something in it, delete it and recreate it. You can use an FTP client or type `mkdir /backup` in the console.
3. Mount the desired folder to `/backup`, using `mount`:

   ```bash
   mount --bind /path/to/new/backup/folder /backup
   ```

For a permanent fix you should add a record to `fstab`, so this folder would mount on your system boot:

1. Open `/etc/fstab`.
2. Add the following line to the end:

   ```bash
   /path/to/new/backup/folder /backup none defaults,bind 0 0
   ```

3. Save the file.

## How to extract .zstd file

Follow the instructions below or use WinRAR 6.10 or later to unpack .zst files.

### How to extract the domain_data.tar.zst in windows using zstd.exe

1. Download and unzip zstd.exe. It is available on the [zstd GitHub](https://github.com/facebook/zstd/releases/).
2. To decompress the backup, use the following command:

   ```batch
   {dir_to_zstd}\zstd.exe -o {dir_to_file}\{file}.tar.zst
   ```

   For example:

   ```batch
   C:\Users\{user}\Downloads\zstd-v1.4.4-win64\zstd.exe -d c:\Users\{user}\Downloads\admin.2021-06-27_05-48-23\web\{domain}\domain_data.tar.zst
   ```

   Output:

   ```batch
   C:\Users\{user}\Downloads\admin.2021-06-27_05-48-23\web\{domain}\domain_data.tar.zst: 61440 bytes
   ```

3. Use your preferred program to untar the resulting tarball, and you are done.
   In this case, the tar was outputted to:

   ```batch
   C:\Users\{user}\Downloads\admin.2021-06-27_05-48-23\web\{domain}\domain_data.tar
   ```
