# Cron Jobs

To manage your cron jobs, navigate to the **Cron <i class="fas fa-fw fa-clock"></i>** tab.

## Toggling cron job notifications

1. To turn them off click the **<i class="fas fa-fw fa-toggle-off"></i> Turn off notifications** button.
2. To turn them back on click the **<i class="fas fa-fw fa-toggle-off"></i> Turn on notifications** button.

## Adding a cron job

1. Click the **<i class="fas fa-fw fa-plus-circle"></i> Add job** button.
2. Enter the command you want to execute.
3. Enter the schedule on which you want to execute the command. You can use the generator to help you, or a tool such as [Crontab.guru](https://crontab.guru/).
4. **Important.** If you use a normal user then you cannot use sudo in cron jobs, Hestia does not add normal users to the sudoers configuration file.

## Editing a cron job

1. Hover over the job you want to edit.
2. Click the <i class="fas fa-fw fa-pencil-alt"><span class="visually-hidden">edit</span></i> icon on the right of the job’s command.

## Suspending a cron job

1. Hover over the job you want to suspend.
2. Click the <i class="fas fa-fw fa-pause"><span class="visually-hidden">suspend</span></i> icon on the right of the job’s command.
3. To unsuspend it, click the <i class="fas fa-fw fa-play"><span class="visually-hidden">unsuspend</span></i> icon on the right of the job’s command.

## Deleting a cron job

1. Hover over the job you want to delete.
2. Click the <i class="fas fa-fw fa-trash"><span class="visually-hidden">delete</span></i> icon on the right of the job’s command.

## Example commands

If you want to run a php script for a user, you can enter the command like this, using the full binary path of the application to run:

```bash
/usr/bin/php8.2 -f /home/user/web/domain.example.com/public_html/cron.php
```
